How to contribute to Contact Form 7
===================================

Thank you for considering contributing to Contact Form 7. This document explains how you can contribute to the project. We ask all contributors to read through this first.


Contributing by reporting issues
--------------------------------

If you find a bug, please report it to our GitHub repository by creating an issue. For minor issues like correction of a typo, you can start by creating a pull request instead of an issue.

If you can fix an issue, create a pull request that links to the target issue. We have our own [coding standards](https://contactform7.com/coding-standards/) for the plugin's development, and we ask that you respect the standards in your coding, too.

Security issues should not be discussed publicly, so when an issue is about a security vulnerability, please use the [contact form](https://contactform7.com/contact/) to inform the developers privately.

In any case, before reporting an issue, please double-check if the issue was caused purely due to a bug seen in the latest version of Contact Form 7. Reporting issues that have little to do with this plugin negatively impacts the motivation of the developers. If you are uncertain, posting it to the [support forum](https://wordpress.org/support/plugin/contact-form-7/) is advised.


Contributing by helping other users
-----------------------------------

Coding is not the only way to contribute to an open source project. Helping other users is also a respected contribution.

Everyday, a lot of users come to the [official support forum](https://wordpress.org/support/plugin/contact-form-7/) to post their support requests. If you feel you can answer their questions, please do not hesitate to do so.

Also, asking good questions in the public forum provides a great contribution. To properly ask a question, you are advised to read through the [forum guidelines](https://wordpress.org/support/welcome/) before posting.


Contributing with translation
-----------------------------

More than half of our users are non-English speakers who use Contact Form 7 in their local languages. Therefore, maintaining translations for their languages is a great help.

We use [translate.wordpress.org](https://translate.wordpress.org/projects/wp-plugins/contact-form-7/) (GlotPress) to manage translations for the Contact Form 7 plugin. This is a collaborative translation platform in which thousands of volunteer translators participate.

For details about how to join the translation project, see [Translating Contact Form 7](https://contactform7.com/translating-contact-form-7/).


Contributing with financial donations
-------------------------------------

You can contribute to the open source project even if you have no technical knowledge. We are asking for [donations](https://contactform7.com/donate/) to help developers sustain the development and support of the plugin.


Contributing by respecting intellectual property rights
-------------------------------------------------------

Contact Form 7 is released under the GNU General Public License (GPL), and copyrights are protected by the license. The name "Contact Form 7" is a trademark we own (see the [trademark policy page](https://contactform7.com/trademark-policy/) for details). Please use this plugin while respecting the intellectual property rights.

There are many WordPress plugins and themes that violate those rights. Please be vigilant and avoid using such abusive products.
