<?php
/**
 * Excellent Blog functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Excellent Blog
 */

if ( ! function_exists( 'excellent_blog_setup' ) ) :
	function excellent_blog_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'excellent-blog', get_stylesheet_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'register_block_pattern' );

		add_theme_support( 'register_block_style' );

		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'excellent_blog_setup' );

if ( ! function_exists( 'excellent_blog_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function excellent_blog_enqueue_styles() {
		$parenthandle = 'refine-blog-style';
		$theme        = wp_get_theme();

		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'refine-blog-slick-style',
				'refine-blog-fontawesome-style',
				'refine-blog-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'excellent-blog-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);
	}

endif;

add_action( 'wp_enqueue_scripts', 'excellent_blog_enqueue_styles' );

// Custom Controls.
require get_theme_file_path() . '/inc/custom-controls.php';

// Customizer Section.
require get_theme_file_path() . '/inc/customizer.php';

/**
 * sanitize image field.
 */
function excellent_blog_sanitize_image( $image, $setting ) {
	/*
	* Array of valid image file types.
	*
	* The array includes image mime types that are included in wp_get_mime_types()
	*/
	$mimes = array(
		'jpg|jpeg|jpe' => 'image/jpeg',
		'gif'          => 'image/gif',
		'png'          => 'image/png',
		'bmp'          => 'image/bmp',
		'tif|tiff'     => 'image/tiff',
		'ico'          => 'image/x-icon',
		'svg'          => 'image/svg+xml',
	);
	// Return an array with file extension and mime_type.
	$file = wp_check_filetype( $image, $mimes );
	// If $image has a valid mime_type, return it; otherwise, return the default.
	return ( $file['ext'] ? $image : $setting->default );
}

function excellent_blog_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'refine_blog_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => 'D10045',
				'width'              => 1000,
				'height'             => 250,
				'flex-height'        => true,
				'wp-head-callback'   => 'refine_blog_header_style',
			)
		)
	);
}
add_action( 'after_setup_theme', 'excellent_blog_custom_header_setup' );

function admin_style() {
	?>
	<style type="text/css">
		.notice.notice-info.refine-blog-demo-data {
			display: none !important;
		}
	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'admin_style' );

/**
 * One Click Demo Import after import setup.
 */
if ( class_exists( 'OCDI_Plugin' ) ) {
	require get_theme_file_path() . '/inc/ocdi.php';
}

/**
 * Renders customizer section link
 */
function excellent_blog_section_link( $section_id ) {
	$section_name      = str_replace( 'excellent_blog_', ' ', $section_id );
	$section_name      = str_replace( '_', ' ', $section_name );
	$starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $starting_notation . $section_id; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}
