<?php
/**
 * Theme Customizer
 *
 * @package Excellent_Blog
 */

function excellent_blog_customize_register( $wp_customize ) {

	require get_theme_file_path() . '/inc/customizer/categories.php';

	// Upsell Section.
	$wp_customize->add_section(
		new Excellent_Blog_Upsell_Section(
			$wp_customize,
			'upsell_sections',
			array(
				'title'            => __( 'Excellent Blog Pro', 'excellent-blog' ),
				'button_text'      => __( 'Buy Pro', 'excellent-blog' ),
				'url'              => 'https://ascendoor.com/themes/excellent-blog-pro/',
				'background_color' => '#D10045',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

}
add_action( 'customize_register', 'excellent_blog_customize_register' );

function excellent_blog_customize_preview_js() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_script( 'excellent-blog-customizer', get_stylesheet_directory_uri() . '/assets/js/customizer' . $min . '.js', array( 'customize-preview', 'refine-blog-customizer' ), '1.0.0', true );
}
add_action( 'customize_preview_init', 'excellent_blog_customize_preview_js' );

function excellent_blog_custom_control_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'excellent-blog-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array( 'refine-blog-custom-controls-css' ), '1.0.0', 'all' );
	wp_enqueue_script( 'excellent-blog-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'refine-blog-custom-controls-js', 'jquery', 'jquery-ui-core' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'excellent_blog_custom_control_scripts' );

/*=====================Active Callback=================*/

// Categories Section.
function excellent_blog_is_categories_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'excellent_blog_enable_categories_section' )->value() );
}
