<?php
/**
 * Categories Section
 *
 * @package Excellent Blog
 */

$wp_customize->add_section(
	'excellent_blog_categories_section',
	array(
		'panel'    => 'refine_blog_front_page_options',
		'title'    => esc_html__( 'Categories Section', 'excellent-blog' ),
		'priority' => 20,
	)
);

// Categories Section - Enable Section.
$wp_customize->add_setting(
	'excellent_blog_enable_categories_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'refine_blog_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'excellent_blog_enable_categories_section',
		array(
			'label'    => esc_html__( 'Enable Categories Section', 'excellent-blog' ),
			'section'  => 'excellent_blog_categories_section',
			'settings' => 'excellent_blog_enable_categories_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'excellent_blog_enable_categories_section',
		array(
			'selector' => '#excellent_blog_categories_section .section-link',
			'settings' => 'excellent_blog_enable_categories_section',
		)
	);
}

// Categories Section - Section Title.
$wp_customize->add_setting(
	'excellent_blog_categories_title',
	array(
		'default'           => __( 'Categories', 'excellent-blog' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'excellent_blog_categories_title',
	array(
		'label'           => esc_html__( 'Section Title', 'excellent-blog' ),
		'section'         => 'excellent_blog_categories_section',
		'settings'        => 'excellent_blog_categories_title',
		'type'            => 'text',
		'active_callback' => 'excellent_blog_is_categories_section_enabled',
	)
);

// Categories Section - Section Subtitle.
$wp_customize->add_setting(
	'excellent_blog_categories_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'excellent_blog_categories_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'excellent-blog' ),
		'section'         => 'excellent_blog_categories_section',
		'settings'        => 'excellent_blog_categories_subtitle',
		'type'            => 'text',
		'active_callback' => 'excellent_blog_is_categories_section_enabled',
	)
);

for ( $i = 1; $i <= 4; $i++ ) {

	// Categories Section - Select Category.
	$wp_customize->add_setting(
		'excellent_blog_categories_content_category_' . $i,
		array(
			'sanitize_callback' => 'refine_blog_sanitize_select',
		)
	);

	$wp_customize->add_control(
		'excellent_blog_categories_content_category_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Category %d', 'excellent-blog' ), $i ),
			'section'         => 'excellent_blog_categories_section',
			'settings'        => 'excellent_blog_categories_content_category_' . $i,
			'active_callback' => 'excellent_blog_is_categories_section_enabled',
			'type'            => 'select',
			'choices'         => refine_blog_get_post_cat_choices(),
		)
	);

	// Categories Section - Category Image.
	$wp_customize->add_setting(
		'excellent_blog_category_category_image_' . $i,
		array(
			'sanitize_callback' => 'excellent_blog_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'excellent_blog_category_category_image_' . $i,
			array(
				'label'           => sprintf( esc_html__( 'Category Image %d', 'excellent-blog' ), $i ),
				'section'         => 'excellent_blog_categories_section',
				'settings'        => 'excellent_blog_category_category_image_' . $i,
				'active_callback' => 'excellent_blog_is_categories_section_enabled',
			)
		)
	);

}
