<?php

/**
 * Active Callbacks
 *
 * @package Refine_Blog
 */

// Theme Options.
function refine_blog_is_pagination_enabled( $control ) {
	return ( $control->manager->get_setting( 'refine_blog_enable_pagination' )->value() );
}
function refine_blog_is_breadcrumb_enabled( $control ) {
	return ( $control->manager->get_setting( 'refine_blog_enable_breadcrumb' )->value() );
}

// Check if static home page is enabled.
function refine_blog_is_static_homepage_enabled( $control ) {
	return ( 'page' === $control->manager->get_setting( 'show_on_front' )->value() );
}

// Banner Slider Section.
function refine_blog_is_banner_slider_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'refine_blog_enable_banner_section' )->value() );
}
function refine_blog_is_banner_slider_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'refine_blog_banner_slider_content_type' )->value();
	return ( refine_blog_is_banner_slider_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function refine_blog_is_banner_slider_section_and_content_type_page_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'refine_blog_banner_slider_content_type' )->value();
	return ( refine_blog_is_banner_slider_section_enabled( $control ) && ( 'page' === $content_type ) );
}
