<?php
/**
 * Breadcrumb
 *
 * @package Refine_Blog
 */

$wp_customize->add_section(
	'refine_blog_breadcrumb',
	array(
		'title'    => esc_html__( 'Breadcrumb', 'refine-blog' ),
		'panel'    => 'refine_blog_theme_options',
		'priority' => 30,
	)
);

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'refine_blog_enable_breadcrumb',
	array(
		'sanitize_callback' => 'refine_blog_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'refine_blog_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'refine-blog' ),
			'section' => 'refine_blog_breadcrumb',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'refine_blog_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'refine_blog_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'refine-blog' ),
		'active_callback' => 'refine_blog_is_breadcrumb_enabled',
		'section'         => 'refine_blog_breadcrumb',
	)
);
