<?php
/**
 * Excerpt
 *
 * @package Refine_Blog
 */

$wp_customize->add_section(
	'refine_blog_excerpt_options',
	array(
		'panel'    => 'refine_blog_theme_options',
		'title'    => esc_html__( 'Excerpt', 'refine-blog' ),
		'priority' => 20,
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'refine_blog_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'refine_blog_sanitize_number_range',
		'validate_callback' => 'refine_blog_validate_excerpt_length',
	)
);

$wp_customize->add_control(
	'refine_blog_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'refine-blog' ),
		'description' => esc_html__( 'Note: Min 1 & Max 100. Please input the valid number and save. Then refresh the page to see the change.', 'refine-blog' ),
		'section'     => 'refine_blog_excerpt_options',
		'settings'    => 'refine_blog_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 100,
			'step' => 1,
		),
	)
);
