<?php
/**
 * Footer Options
 *
 * @package Refine_Blog
 */

$wp_customize->add_section(
	'refine_blog_footer_options',
	array(
		'panel'    => 'refine_blog_theme_options',
		'title'    => esc_html__( 'Footer Options', 'refine-blog' ),
		'priority' => 70,
	)
);

// Footer Options - Copyright Text.
/* translators: 1: Year, 2: Site Title with home URL. */
$copyright_default = sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s', '1: Year, 2: Site Title with home URL', 'refine-blog' ), '[the-year]', '[site-link]' );
$wp_customize->add_setting(
	'refine_blog_footer_copyright_text',
	array(
		'default'           => $copyright_default,
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'refine_blog_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'refine-blog' ),
		'section'  => 'refine_blog_footer_options',
		'settings' => 'refine_blog_footer_copyright_text',
		'type'     => 'textarea',
	)
);

// Footer Options - Scroll Top.
$wp_customize->add_setting(
	'refine_blog_scroll_top',
	array(
		'sanitize_callback' => 'refine_blog_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'refine_blog_scroll_top',
		array(
			'label'   => esc_html__( 'Enable Scroll Top Button', 'refine-blog' ),
			'section' => 'refine_blog_footer_options',
		)
	)
);
