<?php
/**
 * Pagination
 *
 * @package Refine_Blog
 */

$wp_customize->add_section(
	'refine_blog_pagination',
	array(
		'panel'    => 'refine_blog_theme_options',
		'title'    => esc_html__( 'Pagination', 'refine-blog' ),
		'priority' => 60,
	)
);

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'refine_blog_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'refine_blog_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'refine_blog_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'refine-blog' ),
			'section'  => 'refine_blog_pagination',
			'settings' => 'refine_blog_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'refine_blog_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'refine_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'refine_blog_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'refine-blog' ),
		'section'         => 'refine_blog_pagination',
		'settings'        => 'refine_blog_pagination_type',
		'active_callback' => 'refine_blog_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'refine-blog' ),
			'numeric' => __( 'Numeric', 'refine-blog' ),
		),
	)
);
