<?php
/**
 * Post Options
 *
 * @package Refine_Blog
 */

$wp_customize->add_section(
	'refine_blog_post_options',
	array(
		'title'    => esc_html__( 'Post Options', 'refine-blog' ),
		'panel'    => 'refine_blog_theme_options',
		'priority' => 50,
	)
);

// Post Options - Hide Date.
$wp_customize->add_setting(
	'refine_blog_post_hide_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'refine_blog_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'refine_blog_post_hide_date',
		array(
			'label'   => esc_html__( 'Hide Date', 'refine-blog' ),
			'section' => 'refine_blog_post_options',
		)
	)
);

// Post Options - Hide Author.
$wp_customize->add_setting(
	'refine_blog_post_hide_author',
	array(
		'default'           => false,
		'sanitize_callback' => 'refine_blog_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'refine_blog_post_hide_author',
		array(
			'label'   => esc_html__( 'Hide Author', 'refine-blog' ),
			'section' => 'refine_blog_post_options',
		)
	)
);

// Post Options - Hide Category.
$wp_customize->add_setting(
	'refine_blog_post_hide_category',
	array(
		'default'           => false,
		'sanitize_callback' => 'refine_blog_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'refine_blog_post_hide_category',
		array(
			'label'   => esc_html__( 'Hide Category', 'refine-blog' ),
			'section' => 'refine_blog_post_options',
		)
	)
);

// Post Options - Hide Tag.
$wp_customize->add_setting(
	'refine_blog_post_hide_tags',
	array(
		'default'           => false,
		'sanitize_callback' => 'refine_blog_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Refine_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'refine_blog_post_hide_tags',
		array(
			'label'   => esc_html__( 'Hide Tag', 'refine-blog' ),
			'section' => 'refine_blog_post_options',
		)
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'refine_blog_post_related_post_label',
	array(
		'default'           => __( 'Related Posts', 'refine-blog' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'refine_blog_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'refine-blog' ),
		'section'  => 'refine_blog_post_options',
		'settings' => 'refine_blog_post_related_post_label',
		'type'     => 'text',
	)
);


