<?php
/**
 * Sidebar Position
 *
 * @package Refine_Blog
 */

$wp_customize->add_section(
	'refine_blog_sidebar_position',
	array(
		'title'    => esc_html__( 'Sidebar Position', 'refine-blog' ),
		'panel'    => 'refine_blog_theme_options',
		'priority' => 40,
	)
);

// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'refine_blog_sidebar_position',
	array(
		'sanitize_callback' => 'refine_blog_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'refine_blog_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'refine-blog' ),
		'section' => 'refine_blog_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'refine-blog' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'refine-blog' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'refine-blog' ),
		),
	)
);

// Sidebar Position - Post Sidebar Position.
$wp_customize->add_setting(
	'refine_blog_post_sidebar_position',
	array(
		'sanitize_callback' => 'refine_blog_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'refine_blog_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'refine-blog' ),
		'section' => 'refine_blog_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'refine-blog' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'refine-blog' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'refine-blog' ),
		),
	)
);

// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'refine_blog_page_sidebar_position',
	array(
		'sanitize_callback' => 'refine_blog_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'refine_blog_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'refine-blog' ),
		'section' => 'refine_blog_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'refine-blog' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'refine-blog' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'refine-blog' ),
		),
	)
);
