<?php
/**
 * Typography
 *
 * @package Refine_Blog
 */

$wp_customize->add_section(
	'refine_blog_typography',
	array(
		'panel'    => 'refine_blog_theme_options',
		'title'    => esc_html__( 'Typography', 'refine-blog' ),
		'priority' => 10,
	)
);

// Typography - Site Title Font.
$wp_customize->add_setting(
	'refine_blog_site_title_font',
	array(
		'default'           => 'Eczar',
		'sanitize_callback' => 'refine_blog_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'refine_blog_site_title_font',
	array(
		'label'    => esc_html__( 'Site Title Font Family', 'refine-blog' ),
		'section'  => 'refine_blog_typography',
		'settings' => 'refine_blog_site_title_font',
		'type'     => 'select',
		'choices'  => refine_blog_get_all_google_font_families(),
	)
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'refine_blog_site_description_font',
	array(
		'default'           => 'Alegreya Sans',
		'sanitize_callback' => 'refine_blog_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'refine_blog_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'refine-blog' ),
		'section'  => 'refine_blog_typography',
		'settings' => 'refine_blog_site_description_font',
		'type'     => 'select',
		'choices'  => refine_blog_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'refine_blog_header_font',
	array(
		'default'           => 'Literata',
		'sanitize_callback' => 'refine_blog_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'refine_blog_header_font',
	array(
		'label'    => esc_html__( 'Header Font Family', 'refine-blog' ),
		'section'  => 'refine_blog_typography',
		'settings' => 'refine_blog_header_font',
		'type'     => 'select',
		'choices'  => refine_blog_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'refine_blog_body_font',
	array(
		'default'           => 'Alegreya Sans',
		'sanitize_callback' => 'refine_blog_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'refine_blog_body_font',
	array(
		'label'    => esc_html__( 'Body Font Family', 'refine-blog' ),
		'section'  => 'refine_blog_typography',
		'settings' => 'refine_blog_body_font',
		'type'     => 'select',
		'choices'  => refine_blog_get_all_google_font_families(),
	)
);
