<?php

/**
 * Dynamic CSS
 */
function refine_blog_dynamic_css() {

	$site_title_font       = get_theme_mod( 'refine_blog_site_title_font', 'Eczar' );
	$site_description_font = get_theme_mod( 'refine_blog_site_description_font', 'Alegreya Sans' );
	$header_font           = get_theme_mod( 'refine_blog_header_font', 'Literata' );
	$body_font             = get_theme_mod( 'refine_blog_body_font', 'Alegreya Sans' );

	$custom_css  = '';
	$custom_css .= '
    /* Color */
    :root {
        --header-text-color: ' . esc_attr( '#' . get_header_textcolor() ) . ';
    }
    ';

	$custom_css .= '
    /* Typograhpy */
    :root {
        --font-heading: "' . esc_attr( $header_font ) . '", serif;
        --font-main: -apple-system, BlinkMacSystemFont,"' . esc_attr( $body_font ) . '", "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
    }

    body,
	button, input, select, optgroup, textarea {
        font-family: "' . esc_attr( $body_font ) . '", serif;
	}

	.site-title a {
        font-family: "' . esc_attr( $site_title_font ) . '", serif;
	}
    
	.site-description {
        font-family: "' . esc_attr( $site_description_font ) . '", serif;
	}
    ';

	wp_add_inline_style( 'refine-blog-style', $custom_css );

}
add_action( 'wp_enqueue_scripts', 'refine_blog_dynamic_css', 99 );
