<?php
/*This file is part of News Box child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/



function news_box_plus_fonts_url()
{
	$fonts_url = '';

	$font_families = array();

	$font_families[] = 'DM Serif Text:400,400i';
	$font_families[] = 'Noto Serif TC:400,400i,700,700i';

	$query_args = array(
		'family' => urlencode(implode('|', $font_families)),
		'subset' => urlencode('latin,latin-ext'),
	);

	$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');


	return esc_url_raw($fonts_url);
}


function news_box_plus_enqueue_child_styles()
{
	wp_enqueue_style('news-box-plus-google-font', news_box_plus_fonts_url(), array(), null);
	wp_enqueue_style('news-box-plus-parent-style', get_template_directory_uri() . '/style.css', array('bootstrap', 'news-box-default', 'news-box-style'), '', 'all');
	wp_enqueue_style('news-box-plus-main', get_stylesheet_directory_uri() . '/assets/css/main.css', array(), '', 'all');
	wp_enqueue_script('masonry');
	wp_enqueue_script('news-box-plus-mbmenu', get_stylesheet_directory_uri() . '/assets/js/mobile-menu.js', array('jquery'), '1.0.10', true);
}
add_action('wp_enqueue_scripts', 'news_box_plus_enqueue_child_styles');


function news_box_plus_body_classes($classes)
{
	$news_box_plus_view_set = get_theme_mod('view_set', 'grid');

	if ($news_box_plus_view_set == 'grid' && !is_single()) {
		$classes[] = 'news-grid';
	}
	return $classes;
}
add_filter('body_class', 'news_box_plus_body_classes');


// customize include

require get_stylesheet_directory() . '/inc/latest-bar-menu.php';
require get_stylesheet_directory() . '/inc/customizer.php';

/**
 * Filter the except length to 20 words.
 *
 * @param int $length Excerpt length.
 * @return int (Maybe) modified excerpt length.
 */
function news_box_plus_excerpt_more($more)
{
	if (is_admin()) {
		return $more;
	}
	return '';
}
add_filter('excerpt_more', 'news_box_plus_excerpt_more', 999);
