<?php

/**
 * News Box Plus Theme Customizer
 *
 * @package News Box Plus
 */

/*
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function news_box_plus_content_view_sanitize($value)
{
    if (!in_array($value, array('grid', 'card-view', 'default-view'))) {
        $value = 'grid';
    }
    return $value;
}


function news_box_plus_customize_register($wp_customize)
{

    //new
    $wp_customize->remove_control('newsbox_menu_position_control');
    $wp_customize->remove_control('newsbox_container_control');
    $wp_customize->remove_control('news_box_view_set');

    $wp_customize->add_setting('news_box_plus_container', array(
        'default'        => 'container-fluid',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'news_box_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('news_box_plus_container', array(
        'label'      => __('Site container', 'news-box-plus'),
        'description'     => __('Select default page container for your site. News Box support both container and container-fluid.', 'news-box-plus'),
        'section'    => 'news_box_options',
        'settings'   => 'news_box_plus_container',
        'type'       => 'select',
        'choices'    => array(
            'container' => __('Standard container', 'news-box-plus'),
            'container-fluid' => __('Full width container', 'news-box-plus'),
        ),
    ));


    $wp_customize->add_setting('newsbox_plus_menu_position', array(
        'default'        => 'middle',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'news_box_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('newsbox_plus_menu_position', array(
        'label'      => __('Latest Bar Position', 'news-box-plus'),
        'description'     => __('Set menu position top or middle.', 'news-box-plus'),
        'section'    => 'news_box_options',
        'settings'   => 'newsbox_plus_menu_position',
        'type'       => 'select',
        'choices'    => array(
            'top' => __('Top', 'news-box-plus'),
            'middle' => __('Middle', 'news-box-plus'),
        ),
    ));


    /*
    * content view
    */
    $wp_customize->add_setting('news_box_plus_view_set', array(
        'default'        => 'grid',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'news_box_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('news_box_plus_view_set', array(
        'label'      => esc_html__('Select content view style', 'news-box-plus'),
        'section'    => 'news_box_options',
        'settings'   => 'news_box_plus_view_set',
        'priority' => 5,
        'type'       => 'select',
        'choices'    => array(
            'default-view' => esc_html__('Default view', 'news-box-plus'),
            'card-view' => esc_html__('List view', 'news-box-plus'),
            'grid' => esc_html__('Grid view', 'news-box-plus'),
        )
    ));
}
add_action('customize_register', 'news_box_plus_customize_register', 99);
