<?php

/**
 *
 * Header latest Bar
 *
 *
 */

// Blog Eye mobile menu
function news_box_plus_mobile_menu_output()
{
?>
    <div class="mobile-menu-bar">
        <div class="container">
            <nav id="mobile-navigation" class="mobile-navigation">
                <button id="mmenu-btn" class="menu-btn" aria-expanded="false">
                    <span class="mopen"><?php esc_html_e('Menu', 'news-box-plus'); ?></span>
                    <span class="mclose"><?php esc_html_e('Close', 'news-box-plus'); ?></span>
                </button>
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'main-menu',
                    'menu_id'        => 'wsm-menu',
                    'menu_class'        => 'wsm-menu',
                ));
                ?>
            </nav><!-- #site-navigation -->
        </div>
    </div>

<?php
}
add_action('news_box_plus_mobile_menu', 'news_box_plus_mobile_menu_output');


function news_box_plus_header_menu_output()
{
?>
    <nav id="site-navigation" class="main-navigation">
        <?php
        wp_nav_menu(array(
            'theme_location' => 'menu-1',
            'menu_id'        => 'primary-menu',
            'menu_class'        => 'news-box-menu',
        ));
        ?>
    </nav><!-- #site-navigation -->
<?php
}
add_action('news_box_plus_main_menu', 'news_box_plus_header_menu_output');


function newsbox_plus_header_latest_bar()
{
    $news_box_date_show = get_theme_mod('news_box_date_show', 1);
    $newsbox_container = get_theme_mod('newsbox_container', 'container');

?>
    <div class="header-top bg-light header-latest-bar">
        <div class="<?php echo esc_attr($newsbox_container); ?>">
            <div class="headtop-items">
                <div class="header-bottom latest-news-bar">
                    <div class="nbox-ticker">
                        <div class="ticker-title">
                            <div class="news-latest">
                                <?php esc_html_e('Latest News', 'news-box-plus'); ?>
                            </div>
                        </div>
                        <div class="ticker-content">
                            <div class="news-update holder">
                                <?php
                                $news_update_args = array(
                                    'post_type'          =>    'post',
                                    'post_status'          =>    'publish',
                                    'posts_per_page'     => 20,
                                );
                                $news_update_loop = new WP_Query($news_update_args);
                                global $post;
                                while ($news_update_loop->have_posts()) :  $news_update_loop->the_post(); ?>
                                    <div> <?php the_title(); ?>&nbsp; | &nbsp;</div>
                                <?php endwhile;
                                wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="time-column">
                    <div class="date-time time-show">
                        <?php if ($news_box_date_show) : ?>
                            <ul>
                                <li><span class="time"><i class="fa fa-time"></i><?php echo esc_html(date_i18n(get_option('time_format'))); ?></li>
                                <li><span class="time"><?php echo esc_html(date_i18n('l')); ?></span></li>
                                <li><span class="date"><i class="fa fa-date"></i><?php echo esc_html(date_i18n(get_option('date_format'))); ?></span></li>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
}
add_action('newsbox_plus_latest_bar', 'newsbox_plus_header_latest_bar');



function newsbox_plus_header_main_menu()
{
    $newsbox_container = get_theme_mod('newsbox_container', 'container');

?>

    <div class="nxbox-menu-bar">
        <div class="<?php echo esc_attr($newsbox_container); ?>">

            <div class="topnav-serch">

                <?php do_action('news_box_plus_main_menu'); ?>

            </div>
        </div>
    </div>

<?php

}

add_action('newsbox_plus_main_menu', 'newsbox_plus_header_main_menu');
