<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News Box Plus Plus
 */
$news_box_plus_view_set = get_theme_mod('view_set') ? get_theme_mod('view_set') : 'card-view';
$news_box_plus_categories_list = get_the_category_list(esc_html__(' / ', 'news-box-plus'));
?>
<div class="grid-item col-lg-6 mb-4">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="nxgrid">
			<div class="ncard-img">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail(); ?>
				</a>
			</div>
			<div class="nxgrid-body">
				<h2 class="nxgrid-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
				<div class="nxgrid-pmeta">
					<?php
					news_box_posted_on();
					news_box_posted_by();
					?>
				</div>
				<?php the_excerpt(); ?>
				<a href="<?php the_permalink(); ?>" class="nxp-rdbtn"><?php esc_html_e('Read More', 'news-box-plus'); ?></a>
			</div>
		</div>

	</article><!-- #post-<?php the_ID(); ?> -->
</div>